<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_answers extends DAO_Base
{
    protected $table = 'answers';
    protected $pkey  = 'answer_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAll_max_answer_id_DISTINCT_answer_code_BY_yyyymmdd($yyyymmdd, $keys)
    {
        $this->manipulator->setAlias('a');
        $this->manipulator->select('DISTINCT answer_code, MAX(answer_id) as max_answer_id, has_carte');
        $this->manipulator->join('left', 'severitys s');
        $this->manipulator->using('answer_id');
        $this->manipulator->join('LEFT', '
            (select distinct answer_code as has_carte from outpatient_carte) oc ON a.answer_code = oc.has_carte
        ');

        //if ( ! $under16 && ! $over16 ) {
        if ($keys['under16'] !== TRUE && $keys['over16'] !== TRUE) {
            // hit させない
            $this->manipulator->where(array(
                'age' => array('>', 99999),
            ));
        }

        //if ($under16 && ! $over16 ) {
        if ($keys['under16'] === TRUE && $keys['over16'] !== TRUE) {
            // under16 のみ
            $this->manipulator->where(array(
                'age' => array('<', 16),
            ));
        }

        //if ( ! $under16 && $over16) {
        if ($keys['under16'] !== TRUE && $keys['over16'] === TRUE) {
            // over16 のみ
            $this->manipulator->where(array(
                'age' => array('>=', 16),
            ));
        }

        //if ($under16 && $over16) {
        if ($keys['under16'] === TRUE && $keys['over16'] === TRUE) {
            // under16, over16 両方
            $this->manipulator->where(array(
                '(',
                    array('age', '<', 16),
                    'or',
                    array('age', '>=', 16),
                ')'
            ));
        }

        // {{{ 外来カルテ(済/未)..
        if ($keys['diagnosis_done'] === TRUE && $keys['diagnosis_yet'] !== TRUE) {
            // 済:ON, 未:OFFの場合...
            $this->manipulator->ifDefineWhere('and');
            $this->manipulator->where(
                array('has_carte' => array('is not null'))
            );
        }
        if ($keys['diagnosis_done'] !== TRUE && $keys['diagnosis_yet'] === TRUE) {
            // 済:OFF, 未:ONの場合...
            $this->manipulator->ifDefineWhere('and');
            $this->manipulator->where(
                array('has_carte' => array('is null'))
            );
        }
        if ($keys['diagnosis_done'] === TRUE && $keys['diagnosis_yet'] === TRUE) {
            // 済:ON, 未:ONの場合...
            // 外来カルテ有無の条件指定はせず全てが検索対象とする
        }
        if ($keys['diagnosis_done'] !== TRUE && $keys['diagnosis_yet'] !== TRUE) {
            // 済:OFF, 未:OFFの場合...
            // 以下矛盾条件を指定して、１件もヒットさせない
            $this->manipulator->ifDefineWhere('and');
            $this->manipulator->where(array(
                '(',
                    array('has_carte', 'is', NULL),
                'and',
                    array('has_carte', 'is not', NULL),
                ')'
            ));
        }
        // }}}

        // [TODO] どりあえずコメントアウト：後で実装 (2012/02/29)
        // {{{ 重症度...
        /*$severity = array();
        foreach ($keys as $key => $val) {
            if (strpos($key, 'severity') !== FALSE) {
                list($pre, $level) = explode('_', $key);
                if ($level[0] == '4') {
                    // 中等症の場合...
                    if ($val === TRUE) {
                        $severity['match'][] = 4;
                        if ($level == '4h') {
                            // 中等症(高)
                            $severity['risk'] = isset($severity['risk']) ? array_merge($severity['risk'], array(5, 6)) : array(5, 6);
                        } else {
                            // 中等症
                            $severity['risk'] = isset($severity['risk']) ? array_merge($severity['risk'], array(2, 4)) : array(2, 4);
                        }
                    } else {
                        $severity['except'][] = 4;
                    }
                } else {
                    // 軽症、重症、超重症の場合...
                    $severity[($val === TRUE ? 'match' : 'except')][] = (int)$level;
                }
            }
        }*/
        if (! empty($severity['match'])) {
            $this->manipulator->ifDefineWhere('and');
            $this->manipulator->where(
                array('severity1' => array('in', $severity['match']))
            );
        }

        // [TODO] 重症度リスクでの絞込みは不要？
        //if (! empty($severity['risk'])) {
        //    $this->manipulator->ifDefineWhere('and');
        //    $this->manipulator->where(
        //        array('risk' => array('in', $severity['risk']))
        //    );
        //}

        $this->manipulator->ifDefineWhere('and');
        $this->manipulator->where(array(
            'SUBSTRING(SUBSTRING(answer_code, -14), 1, 8)' => $yyyymmdd,
        ));

        $this->manipulator->groupBy(
            'answer_code'
        );

        $result = $this->manipulator->fetchAll();
        return $result;
    }

    public function fetchAll_BY_ids(Array $ids, $offset = '', $limit = '')
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * , SUBSTRING(answer_code, -14) as timestamp');
        $this->manipulator->where(array(
            $this->pkey => array('IN', $ids)
        ));
        $this->manipulator->orderBy(array(
            'timestamp' => 'DESC',
        ));
        if ($offset !== '' && $limit !== '') {
            $this->manipulator->limit($offset, $limit);
        }
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_LEFT_JOIN_severitys_LEFT_JOIN_outpatient_carte_BY_ids(Array $ids, $sort, $offset = '', $limit = '')
    {
        $this->manipulator->setAlias('ans');

        $this->manipulator->select('
            SQL_CALC_FOUND_ROWS ans.*, sev.*, oc.*, oc2.outcome, oc2.diagnosis, vs.*, 
            SUBSTRING(ans.answer_code, -14) as timestamp, 
            CASE WHEN ISNULL(sev.final_severity) THEN sev.base_severity ELSE sev.final_severity END fixed_severity
        ');

        $this->manipulator->join('LEFT', 'severitys sev');
        $this->manipulator->using('answer_id');

        $this->manipulator->join('LEFT', '
            (select answer_code as has_carte, max(outpatient_carte_id) as outpatient_carte_id from outpatient_carte group by answer_code) oc ON ans.answer_code = oc.has_carte
        ');

        $this->manipulator->join('LEFT', '
            outpatient_carte oc2 ON oc2.outpatient_carte_id = oc.outpatient_carte_id
        ');

        $this->manipulator->join('LEFT', '
            vital_sign vs ON vs.answer_code = ans.answer_code
        ');

        $this->manipulator->where(array(
            'ans.answer_id' => array('IN', $ids)
        ));

        if ($sort === 'high') {
            $this->manipulator->orderBy(array('fixed_severity' => 'DESC'));
        } elseif ($sort === 'low') {
            $this->manipulator->orderBy(array('fixed_severity' => 'ASC'));
        } else {
            $this->manipulator->orderBy(array('timestamp' => 'DESC'));
        }

        if ($offset !== '' && $limit !== '') {
            $this->manipulator->limit($offset, $limit);
        }
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_answer_date()
    {
        $this->manipulator->select(' CAST(answer_datetime as DATE) as answer_date ');
        $this->manipulator->groupBy(
            'CAST(answer_datetime as DATE)'
        );
        $this->manipulator->orderBy(array(
            'answer_date' => 'DESC',
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetchNewest_BY_answer_code($answer_code)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'answer_code' => $answer_code, 
        ));
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        $this->manipulator->limit(0, 1);

        return $this->manipulator->fetch();
    }

    public function fetchNewest_LEFT_JOIN_severitys_BY_answer_code($answer_code)
    {
        $this->manipulator->setAlias('ans');

        $this->manipulator->select(
            ' ans.*, sev.*, hkc.*, vs.* '
            // kiou_child...
            . ', kc.q2_text as kc_q2_text' // Birth Data Weight...
            . ', kc.q5 as kc_q5'                    // Immunizations...
            . ', kc.q5_sanshu as kc_q5_sanshu'      // Immunizations...
            . ', kc.q5_nihon as kc_q5_nihon'        // Immunizations...
            . ', kc.q5_bcg_text as kc_q5_bcg_text'  // Immunizations...
            . ', kc.q5_other_text as kc_q5_other_text' // Immunizations...
            . ', kc.q6 as kc_q6'           // Past Illness...
            . ', kc.q6_text as kc_q6_text' // Past Illness...
            . ', kc.q15 as kc_q15'           // Medications...
            . ', kc.q15_text as kc_q15_text' // Medications...
            // 大人(16歳以上)のアレルギー：自由入力に変更のため不要
            // kiou_adult...
            //. ', ka.q17 as ka_q17'           // Allergy...
            //. ', ka.q17_text as ka_q17_text' // Allergy...
        );

        $this->manipulator->join('LEFT', 'severitys sev');
        $this->manipulator->using('answer_id');

        $this->manipulator->join('LEFT', '
            (select answer_code as has_kiou_child, max(kiou_child_id) as kiou_child_id from kiou_child group by answer_code) hkc ON ans.answer_code = hkc.has_kiou_child
        ');
        $this->manipulator->join('LEFT', '
            kiou_child kc ON kc.kiou_child_id = hkc.kiou_child_id
        ');
        $this->manipulator->join('LEFT', '
            (select answer_code as has_kiou_adult, max(kiou_adult_id) as kiou_adult_id from kiou_adult group by answer_code) hka ON ans.answer_code = hka.has_kiou_adult
        ');
        // 大人(16歳以上)のアレルギー：自由入力に変更のため不要
        //$this->manipulator->join('LEFT', '
        //    kiou_adult ka ON ka.kiou_adult_id = hka.kiou_adult_id
        //');

        $this->manipulator->join('LEFT', '
            vital_sign vs ON vs.answer_code = ans.answer_code
        ');

        $this->manipulator->where(array(
            'ans.answer_code' => $answer_code, 
        ));
        $this->manipulator->orderBy(array(
            'ans.' . $this->pkey => 'DESC',
        ));
        $this->manipulator->limit(0, 1);

        return $this->manipulator->fetch();
    }

    public function fetchNewest_BY_card_number($card_number)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'card_number' => $card_number, 
        ));
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        $this->manipulator->limit(0, 1);

        return $this->manipulator->fetch();
    }

    public function fetchAll_BY_card_number($card_number)
    {
        $this->manipulator->select('SQL_CALC_FOUND_ROWS * , SUBSTRING(answer_code, -14) as timestamp');
        $this->manipulator->where(array(
            'card_number' => $card_number,
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_LEFT_JOIN_severitys_LEFT_JOIN_outpatient_carte_BY_card_number($card_number)
    {
        $this->manipulator->setAlias('ans');

        $this->manipulator->select('SQL_CALC_FOUND_ROWS ans.*, sev.*, oc.*, oc2.outcome, oc2.diagnosis , SUBSTRING(ans.answer_code, -14) as timestamp');

        $this->manipulator->join('LEFT', 'severitys sev');
        $this->manipulator->using('answer_id');

        $this->manipulator->join('LEFT', '
            (select answer_code as has_carte, max(outpatient_carte_id) as outpatient_carte_id from outpatient_carte group by answer_code) oc ON ans.answer_code = oc.has_carte
        ');
        $this->manipulator->join('LEFT', '
            outpatient_carte oc2 ON oc2.outpatient_carte_id = oc.outpatient_carte_id
        ');

        $this->manipulator->where(array(
            'ans.card_number' => $card_number,
        ));
        return $this->manipulator->fetchAll();
    }

    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'answer_code', 'card_number', 'birth_y', 'birth_m', 'birth_d', 'gender_div_id', 'weight', 
            'nowtemp', 'maxtemp', 'fromtemp_div_id', 'life_days', 'age', 'age_m', 'zenshin_category_id', 
            'shojo_category_id', 'isGaisho', 'isGoin', 'isNotShojo', 'primaryShojo', 's3_other_disease', 
            's3_other_disease_flg', 's3_no_disease_flg', 'step2_answers', 'step211_answers', 'step212_answers', 
            //'step22_answers', 'step231_answers', 'step232_answers', 'step233_answers', 'step234_answers', 'step235_answers',
            'step22_answers',
            //'step3_answers', 'step31_answers', 'step31_when', 'fever_answers', 'parts_answers', 
            'step3_answers', 'step31_answers', 'step31_when', 'fever_answers', 
            'version', 'doctor_id', 'serialized', 'answer_datetime', 'reg_datetime'
        );
        $this->manipulator->values(array(
            'answer_code'          => $p['answer_code'], 
            'card_number'          => $p['card_number'], 
            'birth_y'              => $p['birth_y'], 
            'birth_m'              => $p['birth_m'], 
            'birth_d'              => $p['birth_d'], 
            'gender_div_id'        => $p['gender_div_id'], 
            'weight'               => $p['weight'], 
            'nowtemp'              => $p['nowtemp'], 
            'maxtemp'              => $p['maxtemp'], 
            'fromtemp_div_id'      => $p['fromtemp_div_id'], 
            'life_days'            => $p['life_days'], 
            'age'                  => $p['age'], 
            'age_m'                => $p['age_m'], 
            'zenshin_category_id'  => $p['zenshin_category_id'], 
            'shojo_category_id'    => $p['shojo_category_id'], 
            'isGaisho'             => $p['isGaisho'], 
            'isGoin'               => $p['isGoin'], 
            'isNotShojo'           => $p['isNotShojo'], 
            'primaryShojo'         => $p['primaryShojo'], 
            's3_other_disease'     => $p['s3_other_disease'], 
            's3_other_disease_flg' => $p['s3_other_disease_flg'], 
            's3_no_disease_flg'    => $p['s3_no_disease_flg'], 
            'step2_answers'        => $p['step2_answers'], 
            'step211_answers'      => $p['step211_answers'], 
            'step212_answers'      => $p['step212_answers'], 
            'step22_answers'       => $p['step22_answers'], 
            //'step231_answers'      => $p['step231_answers'], 
            //'step232_answers'      => $p['step232_answers'], 
            //'step233_answers'      => $p['step233_answers'], 
            //'step234_answers'      => $p['step234_answers'], 
            //'step235_answers'      => $p['step235_answers'], 
            'step3_answers'        => $p['step3_answers'], 
            'step31_answers'       => $p['step31_answers'], 
            'step31_when'          => $p['step31_when'], 
            'fever_answers'        => $p['fever_answers'], 
            //'parts_answers'        => $p['parts_answers'], 
            'version'              => $p['version'], 
            'doctor_id'            => $p['doctor_id'], 
            'serialized'           => $p['serialized'], 
            'answer_datetime'      => $p['answer_datetime'], 
            'reg_datetime'         => $p['reg_datetime'], 
        ));
       return $this->manipulator->insert();
    }

    /*public function update($id, Array $p)
    {
        $this->manipulator->set(array(
            'answer_code'          => $p['answer_code'], 
            'card_number'          => $p['card_number'], 
            'birth_y'              => $p['birth_y'], 
            'birth_m'              => $p['birth_m'], 
            'birth_d'              => $p['birth_d'], 
            'gender_div_id'        => $p['gender_div_id'], 
            'weight'               => $p['weight'], 
            'nowtemp'              => $p['nowtemp'], 
            'maxtemp'              => $p['maxtemp'], 
            'fromtemp_div_id'      => $p['fromtemp_div_id'], 
            'life_days'            => $p['life_days'], 
            'age'                  => $p['age'], 
            'age_m'                => $p['age_m'], 
            'zenshin_category_id'  => $p['zenshin_category_id'], 
            'shojo_category_id'    => $p['shojo_category_id'], 
            'isGaisho'             => $p['isGaisho'], 
            'isGoin'               => $p['isGoin'], 
            'isNotShojo'           => $p['isNotShojo'], 
            'primaryShojo'        => $p['primaryShojo'], 
            's3_other_disease'     => $p['s3_other_disease'], 
            's3_other_disease_flg' => $p['s3_other_disease_flg'], 
            's3_no_disease_flg'    => $p['s3_no_disease_flg'], 
            'step2_answers'        => $p['step2_answers'], 
            'step211_answers'      => $p['step211_answers'], 
            'step212_answers'      => $p['step212_answers'], 
            'step22_answers'       => $p['step22_answers'], 
            'step3_answers'        => $p['step3_answers'], 
            'step31_answers'       => $p['step31_answers'], 
            'step31_when'          => $p['step31_when'], 
            'fever_answers'        => $p['fever_answers'], 
            'version'              => $p['version'], 
            'doctor_id'            => $p['doctor_id'], 
            'serialized'           => $p['serialized'], 
            'answer_datetime'      => $p['answer_datetime'], 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }*/

    public function update_answer_code_AND_card_number_BY_answer_code($answer_code, $new_answer_code, $new_card_number)
    {
        $this->manipulator->set(array(
            'answer_code' => $new_answer_code, 
            'card_number' => $new_card_number, 
        ));
        $this->manipulator->where(array(
            'answer_code' => $answer_code,
        ));
        return $this->manipulator->update();
    }



} //-- End of class


