<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_doctors extends DAO_Base
{
    protected $table = 'doctors';
    protected $pkey  = 'doctor_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetch_active_BY_username_AND_passwd($username, $passwd)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'username' => $username, 
            'and', 
            'passwd' => $passwd, 
            'and', 
            'active_flg' => 1, 
        ));
        return $this->manipulator->fetch();
    }

    public function fetch_BY_username($username)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'username' => $username, 
        ));
        return $this->manipulator->fetch();
    }



    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'active_flg', 'username', 'passwd', 'user_div_code', 'name', 'reg_datetime', 'upd_datetime'
        );
        $this->manipulator->values(array(
            'active_flg'    => 1, 
            'username'      => $p['username'], 
            'passwd'        => $p['passwd'], 
            'user_div_code' => $p['user_div_code'], 
            'name'          => $p['name'], 
            'reg_datetime'  => date('Y-m-d H:i:s'), 
            'upd_datetime'  => NULL, 
        ));
       return $this->manipulator->insert();
    }

    public function update($id, Array $p)
    {
        $this->manipulator->set(array(
            'passwd'        => $p['passwd'], 
            'user_div_code' => $p['user_div_code'], 
            'name'          => $p['name'], 
            'upd_datetime'  => date('Y-m-d H:i:s'), 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }



} //-- End of class


