<?php
/**
 * External Injury Common
 * 
 * LICENSE: 
 * 
 * @copyright 2012 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * External Injury Common Class.
 */
class DAO_external_injury_common extends DAO_Base
{

    protected $table = 'external_injury_common';
    protected $pkey  = 'external_injury_common_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchPartsList()
    {
        $this->manipulator->setTable('external_injury_parts');
        $this->manipulator->setAlias('p');
        $this->manipulator->select('*');
        $this->manipulator->join('left', 'external_injury_group g');
        $this->manipulator->using('external_injury_group_id');
        $this->manipulator->orderBy(array(
            'external_injury_parts_id' => 'asc',
        ));
        $result = $this->manipulator->fetchAll();
        $this->manipulator->setTable($this->table);
        return $result;
    }

    public function fetchAllNameListByKind($kind)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'kind' => $kind,
        ));
        $this->manipulator->orderBy(array(
            'common_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    /**
     * 外傷タイプ(打った、やけど)による共通設問の取得
     * type: 1から17まで
     */
    public function fetchAllNameListByType(array $type)
    {
        $typecol = array();
        $last = count($type) - 1;
        $valid = range(1,17);
        foreach ($type as $key => $val) {
            if (! in_array($val, $valid)) { continue; }
            $cname = 'type' . $val;
            $typecol[$cname] = array('is not null');
            if ($last != $key) {
                $typecol[] = 'or';
            }
        }
        if (empty($typecol)) {
            return;
        }
        // typecolの最後が[or]の場合は削除する
        $last_typecol = NULL;
        foreach ($typecol as $key => $val) {
            $last_typecol = array('key' => $key, 'val' => $val);
        }
        if ($last_typecol['val'] == 'or') {
            unset($typecol[$last_typecol['key']]);
        }
        $this->manipulator->select('*');
        $this->manipulator->where($typecol);
        $this->manipulator->orderBy(array(
            'kind' => 'asc',
            'common_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    /**
     * 外傷タイプ、共通IDによる回答IDの取得
     */
    public function fetchAnswerIdByTypeSeq($type, $id)
    {
        $valid = range(1,17);
        $col = 'type' . $type;
        if (! in_array($type, $valid)) { return; }
        $this->manipulator->setAlias('c');
        $this->manipulator->select($col . ', a.external_injury_answer_selection_id, a.external_injury_question_id, a.answer_selection_name');
        $this->manipulator->join('left', 'external_injury_answer_selection a on a.external_injury_answer_selection_id = c.' . $col);
        $this->manipulator->where(array(
            $this->pkey => $id,
            // 削除フラグはチェックしない。(共通項目は削除フラグONのため)
            //'and',
            //'a.delete_flag' => 0,
        ));
        return $this->manipulator->fetch();
    }

    /**
     * 外傷タイプ、共通IDによる回答IDの取得
     */
    public function fetchAnswerId($type, $id)
    {
        static $list = NULL;
        if (is_null($list)) {
            $list = $this->fetchAllNameListByType(range(1,17));
        }
        $result = FALSE;
        $col = 'type' . $type;
        foreach ($list as $val) {
            if ($val['external_injury_common_id'] == $id && ! empty($val[$col])) {
                $result = $val[$col];
            }
        }
        return $result;
    }

}

?>
