<?php
/**
 * External Injury Level
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * External Injury Level Class.
 */
class DAO_external_injury_level extends DAO_Base
{

    protected $table = 'external_injury_level';
    protected $pkey  = '';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    private function getSeriousLevelColumnName($life_days)
    {
        switch (TRUE) {
            case (0 <= $life_days && $life_days <= 30) :      // 0-30日
                $suffix = 'a';
                break;
            case (31 <= $life_days && $life_days <= 90) :     // 31-90日
                $suffix = 'b';
                break;
            case (91 <= $life_days && $life_days <= 240) :    // 91-240日
                $suffix = 'c';
                break;
            case (241 <= $life_days && $life_days <= 365) :   // 241-356日
                $suffix = 'd';
                break;
            case (366 <= $life_days && $life_days <= 730) :   // 1-2歳
                $suffix = 'e';
                break;
            case (731 <= $life_days && $life_days <= 1825) :  // 3-5歳
                $suffix = 'f';
                break;
            case (1826 <= $life_days && $life_days <= 2190) : // 6-8歳
                $suffix = 'g';
                break;
            case (2191 <= $life_days && $life_days <= 4380) : // 9-12歳
                $suffix = 'h';
                break;
            case (4381 <= $life_days) :                       // 13歳以上
                $suffix = 'i';
                break;
            default :                                         // 13歳以上(デフォルト)
                $suffix = 'i';
        }
        $result = 'serious_level_' . $suffix;
        return $result;
    }

    public function fetchExternalInjuryLevelMax(array $qa, $life_days)
    {
        $level_colname = $this->getSeriousLevelColumnName($life_days);
        $this->manipulator->select('max(' . $level_colname . ') as serious_level');
        foreach ((array)$qa as $val) {
            $this->manipulator->ifDefineWhere('or');
            $this->manipulator->where(array(
                        '(',
                        array('target_kind', '=', $val['target_kind']),
                        'and',
                        array('question_id', '=', $val['question_id']),
                        'and',
                        array('answer_selection_id', '=', $val['answer_selection_id']),
                        ')',
                        ));
        }
	// 回答データは削除フラグをチェックしない(共通項目は削除フラグがONのため)
        //$this->manipulator->ifDefineWhere('and');
        //$this->manipulator->where(array(
        //    'delete_flag' => '0',
        //));
        return $this->manipulator->fetchColumn();
    }

    public function fetchAllExternalInjuryLevel(array $qa, $life_days)
    {
        $level_colname = $this->getSeriousLevelColumnName($life_days);
        $this->manipulator->select('target_kind, question_id, answer_selection_id, ' . $level_colname . ' as serious_level, delete_flag');
        foreach ((array)$qa as $val) {
            $this->manipulator->ifDefineWhere('or');
            $this->manipulator->where(array(
                        '(',
                        array('target_kind', '=', $val['target_kind']),
                        'and',
                        array('question_id', '=', $val['question_id']),
                        'and',
                        array('answer_selection_id', '=', $val['answer_selection_id']),
                        ')',
                        ));
        }
        $this->manipulator->ifDefineWhere('and');
        $this->manipulator->where(array(
            'delete_flag' => '0',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
