<?php
/**
 * External Injury Type
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * External Injury Type Class.
 */
class DAO_external_injury_type extends DAO_Base
{

    protected $table = 'external_injury_type';
    protected $pkey  = 'external_injury_type_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchExternalInjuryTypeById($id)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'delete_flag' => '0',
            'and',
            $this->pkey => $id,
        ));
        return $this->manipulator->fetch();
    }

    public function fetchAllExternalInjuryType($node_id = FALSE)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'delete_flag' => '0',
        ));
        if ($node_id !== FALSE) {
            $this->manipulator->where(array(
                'and',
                'node_id' => $node_id,
            ));
        }
        $this->manipulator->orderBy(array(
            'order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

?>
