<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_family_card_number extends DAO_Base
{
    protected $table = 'family_card_number';
    protected $pkey  = '';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAll_BY_card_number($card_number)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'card_number' => $card_number,
        ));
        return $this->manipulator->fetchAll();
    }

    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'card_number', 'family_card_number', 'family_div_id'
        );
        $this->manipulator->values(array(
            'card_number'        => $p['card_number'], 
            'family_card_number' => $p['family_card_number'], 
            'family_div_id'      => $p['family_div_id'], 
        ));
       return $this->manipulator->insert();
    }

    public function delete_BY_card_number($card_number)
    {
        $this->manipulator->where(array(
            'card_number' => $card_number
        ));
        return $this->manipulator->delete();
    }



} //-- End of class


