<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_family_history extends DAO_Base
{
    protected $table = 'family_history';
    protected $pkey  = 'family_history_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAll_BY_card_number($card_number)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'card_number' => $card_number,
        ));
        $this->manipulator->orderBy(array(
            'orderby' => 'ASC',
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetch_BY_card_number_AND_type($card_number, $type)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'card_number' => $card_number,
            'and',
            'type' => $type,
        ));
        return $this->manipulator->fetch();
    }

    public function insert(Array $p, $now_datetime)
    {
        $this->manipulator->columns(
            'card_number', 'type', 'class', 'label', 'alive', 'cohabitation', 'age', 'serious_disease', 
            'serious_disease_name', 'serious_disease_y', 'serious_disease_m', 'serious_disease_d', 
            'serious_disease_status', 'allergy', 'allergy_items', 'allergy_y', 'allergy_m', 'allergy_d', 
            'allergy_status', 'self_card_number', 'gender_div_id', 'generation', 'divorce_flg', 
            'twins_div_id', 'disease_status_div_id', 'orderby', 'reg_datetime', 'upd_datetime'
        );
        $this->manipulator->values(array(
            'card_number'            => $p['card_number'], 
            'type'                   => $p['type'], 
            'class'                  => $p['class'], 
            'label'                  => $p['label'], 
            'alive'                  => $p['alive'], 
            'cohabitation'           => $p['cohabitation'], 
            'age'                    => $p['age'], 
            'serious_disease'        => $p['serious_disease'], 
            'serious_disease_name'   => $p['serious_disease_name'], 
            'serious_disease_y'      => $p['serious_disease_y'], 
            'serious_disease_m'      => $p['serious_disease_m'], 
            'serious_disease_d'      => $p['serious_disease_d'], 
            'serious_disease_status' => $p['serious_disease_status'], 
            'allergy'                => $p['allergy'], 
            'allergy_items'          => $p['allergy_items'], 
            'allergy_y'              => $p['allergy_y'], 
            'allergy_m'              => $p['allergy_m'], 
            'allergy_d'              => $p['allergy_d'], 
            'allergy_status'         => $p['allergy_status'], 
            'self_card_number'       => $p['self_card_number'], 
            'gender_div_id'          => $p['gender_div_id'], 
            'generation'             => $p['generation'], 
            'divorce_flg'            => $p['divorce_flg'], 
            'twins_div_id'           => $p['twins_div_id'], 
            'disease_status_div_id'  => $p['disease_status_div_id'], 
            'orderby'                => $p['orderby'], 
            'reg_datetime'           => $now_datetime, 
            'upd_datetime'           => $now_datetime, 
        ));
       return $this->manipulator->insert();
    }

    public function update($id, Array $p, $upd_datetime)
    {
        $this->manipulator->set(array(
            'card_number'            => $p['card_number'], 
            'type'                   => $p['type'], 
            'class'                  => $p['class'], 
            'label'                  => $p['label'], 
            'alive'                  => $p['alive'], 
            'cohabitation'           => $p['cohabitation'], 
            'age'                    => $p['age'], 
            'serious_disease'        => $p['serious_disease'], 
            'serious_disease_name'   => $p['serious_disease_name'], 
            'serious_disease_y'      => $p['serious_disease_y'], 
            'serious_disease_m'      => $p['serious_disease_m'], 
            'serious_disease_d'      => $p['serious_disease_d'], 
            'serious_disease_status' => $p['serious_disease_status'], 
            'allergy'                => $p['allergy'], 
            'allergy_items'          => $p['allergy_items'], 
            'allergy_y'              => $p['allergy_y'], 
            'allergy_m'              => $p['allergy_m'], 
            'allergy_d'              => $p['allergy_d'], 
            'allergy_status'         => $p['allergy_status'], 
            'self_card_number'       => $p['self_card_number'], 
            'gender_div_id'          => $p['gender_div_id'], 
            'generation'             => $p['generation'], 
            'divorce_flg'            => $p['divorce_flg'], 
            'twins_div_id'           => $p['twins_div_id'], 
            'disease_status_div_id'  => $p['disease_status_div_id'], 
            'orderby'                => $p['orderby'], 
            'upd_datetime'           => $upd_datetime, 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }

    public function delete_BY_card_number_NOT_upd_datetime($card_number, $upd_datetime)
    {
        $this->manipulator->where(array(
            'card_number' => $card_number,
            'and',
            'upd_datetime' => array('<>', $upd_datetime),
        ));
        return $this->manipulator->delete();
    }



} //-- End of class


