<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_kiou_base.php';

class DAO_kiou_child extends DAO_kiou_base
{
    protected $table = 'kiou_child';
    protected $pkey  = 'kiou_child_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchNewest_BY_card_number($card_number)
    {
        $this->manipulator->select(' * ');
        $this->manipulator->where(array(
            'card_number' => $card_number, 
        ));
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        return $this->manipulator->fetch();
    }



    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'answer_code', 'card_number', 'status', 'reason', 'q1', 'q1_a', 'q1_a_text', 'q2_text', 
            'q3', 'q3_text', 'q4', 'q4_text', 'q5', 'q5_sanshu', 'q5_nihon', 'q5_bcg_text', 'q5_other_text', 
            'q6', 'q6_text', 'q7', 'q7_text', 'q8', 'q8_text', 'q9', 'q9_medicine_text', 'q9_food_text', 
            'q9_contact_text', 'q15', 'q15_text', 'q16', 'q16_medicine', 'q16_other_text', 
            'q17', 'q17_disease', 'q17_other_text', 'same_symptoms', 'reg_datetime'
        );
        $this->manipulator->values(array(
            'answer_code'      => isset($p['answer_code']) ? $p['answer_code'] : '', 
            'card_number'      => isset($p['card_number']) ? $p['card_number'] : '', 
            'status'           => isset($p['status']) ? $p['status'] : '', 
            'reason'           => isset($p['reason']) ? $p['reason'] : '', 
            'q1'               => isset($p['q1']) ? $p['q1'] : '', 
            'q1_a'             => isset($p['q1_a']) ? $p['q1_a'] : '', 
            'q1_a_text'        => isset($p['q1_a_text']) ? $p['q1_a_text'] : '', 
            'q2_text'          => isset($p['q2_text']) ? $p['q2_text'] : '', 
            'q3'               => isset($p['q3']) ? $p['q3'] : '', 
            'q3_text'          => isset($p['q3_text']) ? $p['q3_text'] : '', 
            'q4'               => isset($p['q4']) ? $p['q4'] : '', 
            'q4_text'          => isset($p['q4_text']) ? $p['q4_text'] : '', 
            'q5'               => isset($p['q5']) ? $p['q5'] : '', 
            'q5_sanshu'        => isset($p['q5_sanshu']) ? $p['q5_sanshu'] : '', 
            'q5_nihon'         => isset($p['q5_nihon']) ? $p['q5_nihon'] : '', 
            'q5_bcg_text'      => isset($p['q5_bcg_text']) ? $p['q5_bcg_text'] : '', 
            'q5_other_text'    => isset($p['q5_other_text']) ? $p['q5_other_text'] : '', 
            'q6'               => isset($p['q6']) ? $p['q6'] : '', 
            'q6_text'          => isset($p['q6_text']) ? $p['q6_text'] : '', 
            'q7'               => isset($p['q7']) ? $p['q7'] : '', 
            'q7_text'          => isset($p['q7_text']) ? $p['q7_text'] : '', 
            'q8'               => isset($p['q8']) ? $p['q8'] : '', 
            'q8_text'          => isset($p['q8_text']) ? $p['q8_text'] : '', 
            'q9'               => isset($p['q9']) ? $p['q9'] : '', 
            'q9_medicine_text' => isset($p['q9_medicine_text']) ? $p['q9_medicine_text'] : '', 
            'q9_food_text'     => isset($p['q9_food_text']) ? $p['q9_food_text'] : '', 
            'q9_contact_text'  => isset($p['q9_contact_text']) ? $p['q9_contact_text'] : '', 
            'q15'              => isset($p['q15']) ? $p['q15'] : '', 
            'q15_text'         => isset($p['q15_text']) ? $p['q15_text'] : '', 
            'q16'              => isset($p['q16']) ? $p['q16'] : '', 
            'q16_medicine'     => isset($p['q16_medicine']) ? $p['q16_medicine'] : '', 
            'q16_other_text'   => isset($p['q16_other_text']) ? $p['q16_other_text'] : '', 
            'q17'              => isset($p['q17']) ? $p['q17'] : '', 
            'q17_disease'      => isset($p['q17_disease']) ? $p['q17_disease'] : '', 
            'q17_other_text'   => isset($p['q17_other_text']) ? $p['q17_other_text'] : '', 
            'same_symptoms'    => isset($p['same_symptoms']) ? $p['same_symptoms'] : '', 
            'reg_datetime'     => isset($p['reg_datetime']) ? $p['reg_datetime'] : '', 
        ));
       return $this->manipulator->insert();
    }

    /*public function update($id, Array $p)
    {
        $this->manipulator->set(array(
            'answer_code'      => $p['answer_code'], 


            'card_number'      => $p['card_number'], 
            'status'           => $p['status'], 
            'reason'           => $p['reason'], 
            'q1'               => $p['q1'], 
            'q1_a'             => $p['q1_a'], 
            'q1_a_text'        => $p['q1_a_text'], 
            'q2_text'          => $p['q2_text'], 
            'q3'               => $p['q3'], 
            'q3_text'          => $p['q3_text'], 
            'q4'               => $p['q4'], 
            'q4_text'          => $p['q4_text'], 
            'q5'               => $p['q5'], 
            'q5_sanshu'        => $p['q5_sanshu'], 
            'q5_nihon'         => $p['q5_nihon'], 
            'q5_bcg_text'      => $p['q5_bcg_text'], 
            'q5_other_text'    => $p['q5_other_text'], 
            'q6'               => $p['q6'], 
            'q6_text'          => $p['q6_text'], 
            'q7'               => $p['q7'], 
            'q7_text'          => $p['q7_text'], 
            'q8'               => $p['q8'], 
            'q8_text'          => $p['q8_text'], 
            'q9'               => $p['q9'], 
            'q9_medicine_text' => $p['q9_medicine_text'], 
            'q9_food_text'     => $p['q9_food_text'], 
            'q9_contact_text'  => $p['q9_contact_text'], 
            'q10'              => $p['q10'], 
            'q11'              => $p['q11'], 
            'q11_text'         => $p['q11_text'], 
            'q12'              => $p['q12'], 
            'q12_family'       => $p['q12_family'], 
            'q12other_text'    => $p['q12other_text'], 
            'q13'              => $p['q13'], 
            'q13_family'       => $p['q13_family'], 
            'q13_other_text'   => $p['q13_other_text'], 
            'q14'              => $p['q14'], 
            'q14_family'       => $p['q14_family'], 
            'q14_other_text'   => $p['q14_other_text'], 
            'q15'              => $p['q15'], 
            'q15_text'         => $p['q15_text'], 
            'q16'              => $p['q16'], 
            'q16_medicine'     => $p['q16_medicine'], 
            'q16_other_text'   => $p['q16_other_text'], 
            'q17'              => $p['q17'], 
            'q17_disease'      => $p['q17_disease'], 
            'q17_other_text'   => $p['q17_other_text'], 
            'q18'              => $p['q18'], 
            'same_symptoms' => isset($p['same_symptoms']) ? join(',', $p['same_symptoms']) : null, 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }*/



} //-- End of class


