<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_outpatient_carte extends DAO_Base
{
    protected $table = 'outpatient_carte';
    protected $pkey  = 'outpatient_carte_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAll_BY_answer_code($answer_code)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'answer_code' => $answer_code,
        ));
        $this->manipulator->orderBy(array(
            $this->pkey => 'DESC',
        ));
        return $this->manipulator->fetchAll();
    }

    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'answer_code', 'data', 'doctor_id', 'reg_datetime'
            , 'outcome', 'diagnosis'
        );
        $this->manipulator->values(array(
            'answer_code'  => $p['answer_code'], 
            'data'         => $p['data'], 
            'doctor_id'    => $p['doctor_id'], 
            'reg_datetime' => date('Y-m-d H:i:s'), 
            'outcome'      => $p['outcome'],
            'diagnosis'    => $p['diagnosis'],
        ));
       return $this->manipulator->insert();
    }

    /*public function update($id, Array $p)
    {
        $this->manipulator->set(array(
            'answer_code'  => $p['answer_code'], 
            'data'         => $p['data'], 
            'doctor_id'    => $p['doctor_id'], 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }*/



}


