<?php
/**
 * Patient Code
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Patient Code Class.
 */
class DAO_patient_code extends DAO_Base
{

    protected $table = 'patient_code';
    protected $pkey  = 'card_number';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchPatientCode($card_number)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'card_number' => $card_number,
        ));
        return $this->manipulator->fetch();
    }

    public function isCardNumber($card_number)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'card_number' => $card_number,
        ));
        $data = $this->manipulator->fetch();
        $result = ($data['card_number'] == $card_number);
        return $result;
    }

    public function insert(array $p)
    {
        if ($this->isCardNumber($p['card_number'])) {
            // 既に診察券番号が存在する場合...
            $result =  $this->update($p);
        } else {
            // 診察券番号の新規登録...
            $date = date('Y-m-d H:i:s');
            $this->manipulator->columns(
                'card_number', 'patient_code', 'insurance_no', 'insurance_name', 'date_regist', 'date_update'
            );
            $this->manipulator->values(array(
                'card_number'  => $p['card_number'], 
                'patient_code' => $p['patient_code'], 
                'insurance_no' => $p['insurance_no'], 
                'insurance_name' => $p['insurance_name'], 
                'date_regist'  => $date,
                'date_update'  => $date,
            ));
           $result = $this->manipulator->insert();
        }
        return $result;
    }

    public function update(array $p)
    {
        $date = date('Y-m-d H:i:s');
        $this->manipulator->set(array(
            'patient_code' => $p['patient_code'], 
            'insurance_no' => $p['insurance_no'], 
            'insurance_name' => $p['insurance_name'], 
            'date_update'  => $date,
        ));
        $this->manipulator->where(array(
            'card_number'  => $p['card_number'], 
        ));
       return $this->manipulator->update();
    }

}

?>
