<?php
/**
 * データアクセスオブジェクト
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_severitys extends DAO_Base
{
    protected $table = 'severitys';
    protected $pkey  = 'severity_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetch_BY_answer_id($answer_id)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'answer_id' => $answer_id,
        ));
        return $this->manipulator->fetch();
    }

    public function fetch_LEFT_JOIN_answers_BY_answer_id($answer_id)
    {
        $this->manipulator->setAlias('sev');
        $this->manipulator->select('SQL_CALC_FOUND_ROWS sev.*, ans.*');
        $this->manipulator->join('LEFT', 'answers ans');
        $this->manipulator->using('answer_id');
        $this->manipulator->where(array(
            'answer_id' => $answer_id,
        ));
        return $this->manipulator->fetch();
    }

    public function insert($answer_id, Array $p)
    {
        $this->manipulator->columns(
            'answer_id', 'zenshin', 'shojo1', 'shojo2', 'shojo3', 'fever', 'gaisho1', 'gaisho2', 'gaisho3', 
            //'base_severity', 'final_severity', 'serious_level', 'reg_datetime', 'upd_datetime', 'doctor_id'
            'base_severity', 'final_severity', 'reg_datetime', 'upd_datetime', 'doctor_id'
        );
        $this->manipulator->values(array(
            'answer_id'    => $answer_id, 
            'zenshin'      => $p['zenshin'], 
            'shojo1'       => $p['shojo1'], 
            'shojo2'       => $p['shojo2'], 
            'shojo3'       => $p['shojo3'], 
            'fever'        => $p['fever'], 
            'gaisho1'      => $p['gaisho1'], 
            'gaisho2'      => $p['gaisho2'], 
            'gaisho3'      => $p['gaisho3'], 
            'base_severity'  => $p['base_severity'], 
            'final_severity' => null, 
            //'serious_level'  => $p['serious_level'], 
            'reg_datetime' => date('Y-m-d H:i:s'), 
            'upd_datetime' => null, 
            'doctor_id'    => null, 

        ));
       return $this->manipulator->insert();
    }

    public function update_final_severity_AND_doctor_id_BY_id($id, $final_severity, $doctor_id)
    {
        $this->manipulator->set(array(
            'final_severity' => $final_severity, 
            'upd_datetime'   => date('Y-m-d H:i:s'), 
            'doctor_id'      => $doctor_id, 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }



} //-- End of class



