<?php
/**
 * Therapeutic Plan Treatment
 * 
 * LICENSE: 
 * 
 * @copyright 2012 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Therapeutic Plan Treatment Class.
 */
class DAO_tx_treatment extends DAO_Base
{

    protected $table = 'tx_treatment';
    protected $pkey  = 'tx_treatment_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAll_Category()
    {
        $cols = 'tx_category_id, category_name';
        $this->manipulator->setTable('tx_category');
        $this->manipulator->select($cols);
        $this->manipulator->where(array(
            'valid_flag' => 1,
        ));
        $this->manipulator->orderBy(array(
            'order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_Group()
    {
        $this->manipulator->setTable('tx_group');
        $cols = 'c.tx_category_id, c.category_name';
        $cols .= ', g.tx_group_id, g.group_name, g.alias_id';
        $this->manipulator->setAlias('g');
        $this->manipulator->select($cols);
        $this->manipulator->join('left', 'tx_category_relation cg');
        $this->manipulator->using('tx_group_id');
        $this->manipulator->join('LEFT', 'tx_category c');
        $this->manipulator->using('tx_category_id');
        $this->manipulator->where(array(
            'g.valid_flag' => 1,
            'and',
            'c.valid_flag' => 1,
        ));
        $this->manipulator->orderBy(array(
            'c.order_num' => 'asc',
            'cg.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    public function fetchAll_TreatmentList($monshin_type)
    {
        $this->manipulator->setTable($this->table);
        $cols = 't.tx_treatment_id, t.monshin_type';
        $cols .= ', r.tx_recipe_id, r.recipe_name, r.quantity_flag, r.unit';
        $cols .= ', g.tx_group_id, g.group_name, g.alias_id';
        $cols .= ', c.tx_category_id, c.category_name';
        $this->manipulator->setAlias('t');
        $this->manipulator->select($cols);
        $this->manipulator->join('left', 'tx_recipe r');
        $this->manipulator->using('tx_recipe_id');
        $this->manipulator->join('left', 'tx_group g');
        $this->manipulator->using('tx_group_id');
        $this->manipulator->join('left', 'tx_category_relation cg');
        $this->manipulator->using('tx_group_id');
        $this->manipulator->join('left', 'tx_category c on c.tx_category_id = t.tx_category_id');
        $this->manipulator->where(array(
            't.valid_flag' => 1,
            'and',
            'r.valid_flag' => 1,
            'and',
            'g.valid_flag' => 1,
            'and',
            'c.valid_flag' => 1,
        ));
        if (! empty($monshin_type)) {
            $this->manipulator->where(array(
                'and',
                'monshin_type' => $monshin_type,
            ));
        }
        $this->manipulator->groupBy($cols);
        $this->manipulator->orderBy(array(
            'c.order_num' => 'asc',
            'cg.order_num' => 'asc',
            't.order_num' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

}

