<?php
/**
 * f[^ANZXIuWFNg
 */

require_once dirname(__FILE__).'/DAO_Base.php';

class DAO_vital_sign extends DAO_Base
{
    protected $table = 'vital_sign';
    protected $pkey  = 'vital_sign_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetch_BY_answer_code($answer_code)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'answer_code' => $answer_code,
        ));
        return $this->manipulator->fetch();
    }

    public function insert(Array $p)
    {
        $this->manipulator->columns(
            'answer_code', 'body_temperature', 'heart_rate', 'respiratory_rate', 'spo2', 'room_air_flag', 
            'o2_flag', 'o2', 'blood_pressure_lr_flag', 'blood_pressure_low', 'blood_pressure_high', 
            'blood_pressure_l_low', 'blood_pressure_l_high', 'blood_pressure_r_low', 'blood_pressure_r_high', 
            'reg_datetime', 'upd_datetime', 'doctor_id'
        );
        $this->manipulator->values(array(
            'answer_code'            => $p['answer_code'], 
            'body_temperature'       => '', 
            'heart_rate'             => '', 
            'respiratory_rate'       => '', 
            'spo2'                   => '', 
            'room_air_flag'          => 0, 
            'o2_flag'                => 0, 
            'o2'                     => '', 
            'blood_pressure_lr_flag' => 0, 
            'blood_pressure_low'     => '', 
            'blood_pressure_high'    => '', 
            'blood_pressure_l_low'   => '', 
            'blood_pressure_l_high'  => '', 
            'blood_pressure_r_low'   => '', 
            'blood_pressure_r_high'  => '', 
            'reg_datetime'           => date('Y-m-d H:i:s'), 
            'upd_datetime'           => NULL, 
            'doctor_id'              => NULL, 
        ));
       return $this->manipulator->insert();
    }

    public function update_assessment_flag_BY_answer_code($answer_code, Array $p)
    {
        $this->manipulator->set(array(
            'assessment_flag' => $p['assessment_flag'], 
            'upd_datetime'    => date('Y-m-d H:i:s'), 
            'doctor_id'       => $p['doctor_id'], 
        ));
        $this->manipulator->where(array(
            'answer_code' => $answer_code,
        ));
        return $this->manipulator->update();
    }

    public function update_minimum_BY_answer_code($answer_code, Array $p)
    {
        $this->manipulator->set(array(
            'body_temperature'    => $p['body_temperature'], 
            'heart_rate'          => $p['heart_rate'], 
            'respiratory_rate'    => $p['respiratory_rate'], 
            'spo2'                => $p['spo2'], 
            'blood_pressure_low'  => $p['blood_pressure_low'], 
            'blood_pressure_high' => $p['blood_pressure_high'], 
            'upd_datetime'        => date('Y-m-d H:i:s'), 
            'doctor_id'           => $p['doctor_id'], 
        ));
        $this->manipulator->where(array(
            'answer_code' => $answer_code,
        ));
        return $this->manipulator->update();
    }

    public function update_BY_answer_code($answer_code, Array $p)
    {
        $this->manipulator->set(array(
            'body_temperature'       => $p['body_temperature'], 
            'heart_rate'             => $p['heart_rate'], 
            'respiratory_rate'       => $p['respiratory_rate'], 
            'spo2'                   => $p['spo2'], 
            'room_air_flag'          => $p['room_air_flag'], 
            'o2_flag'                => $p['o2_flag'], 
            'o2'                     => $p['o2'], 
            'blood_pressure_lr_flag' => $p['blood_pressure_lr_flag'], 
            'blood_pressure_low'     => $p['blood_pressure_low'], 
            'blood_pressure_high'    => $p['blood_pressure_high'], 
            'blood_pressure_l_low'   => $p['blood_pressure_l_low'], 
            'blood_pressure_l_high'  => $p['blood_pressure_l_high'], 
            'blood_pressure_r_low'   => $p['blood_pressure_r_low'], 
            'blood_pressure_r_high'  => $p['blood_pressure_r_high'], 
            'dx_flag'                => $p['dx_flag'], 
            'tx_flag'                => $p['tx_flag'], 
            'assessment_flag'        => $p['assessment_flag'], 
            'upd_datetime'           => date('Y-m-d H:i:s'), 
            'doctor_id'              => $p['doctor_id'], 
        ));
        $this->manipulator->where(array(
            'answer_code' => $answer_code,
        ));
        return $this->manipulator->update();
    }



}
