<?php
/**
 * Xml Partitions
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Xml Partitions Class.
 */
class DAO_xml_partitions extends DAO_Base
{

    protected $table = 'INFORMATION_SCHEMA.PARTITIONS';
    protected $pkey  = '';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
        $this->pname = 'p' . date('Ym');
        $this->ndate = date('Y-m-01', strtotime('next month'));
    }

    public function isPartition($table)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'TABLE_SCHEMA' => DB_NAME,
            'and',
            'TABLE_NAME' => $table,
        ));
        $info = $this->manipulator->fetch();
        $result = ! is_null($info['PARTITION_NAME']);
        return $result;
    }

    public function isThisMonthPartition($table)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'TABLE_SCHEMA' => DB_NAME,
            'and',
            'TABLE_NAME' => $table,
            'and',
            'PARTITION_NAME' => $this->pname,
        ));
        $info = $this->manipulator->fetch();
        $result = ($info['PARTITION_NAME'] == $this->pname);
        return $result;
    }

    public function createThisMonthPartition($table)
    {
        $query = 'alter table ' . $table;
        if ($this->isPartition($table)) {
            // パーティション追加...
            $query .= ' add partition (';
        } else {
            // パーティション作成...
            $query .= ' partition by range (to_days(date_regist)) (';
        }
        $query .= 'partition ' . $this->pname;
        $query .= ' values less than (to_days(\'' . $this->ndate . '\'))';
        $query .= ' comment = \'less than ' . $this->ndate . '\');';
        $stat = $this->manipulator->rawQuery('execute', $query);
        return $stat;
    }

}

?>
