<?php
/**
 * Xml Recipe
 * 
 * LICENSE: 
 * 
 * @copyright 2011 Topazos, Inc.
 * @license http://www.topazos.co.jp/license/3_0.txt PHP License 3.0
 * @version CVS: $Id: $
 * @link http://www.topazos.co.jp/package/PackageName
 * @since File available since Release 1.0.0
 */

require_once dirname(__FILE__) . '/DAO_Base.php';

/**
 * Xml Recipe Class.
 */
class DAO_xml_recipe extends DAO_Base
{

    protected $table = 'xml_recipe';
    protected $pkey  = 'xml_recipe_id';

    public function __construct()
    {
        parent::__construct();
        $this->manipulator->setTable($this->table);
    }

    public function fetchAllXmlRecipeByExportFlag($flag = '0')
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'export_flag' => $flag,
        ));
        $this->manipulator->orderBy(array(
            'date_regist' => 'asc',
        ));
        return $this->manipulator->fetchAll();
    }

    public function isFileName($file)
    {
        $this->manipulator->select('*');
        $this->manipulator->where(array(
            'export_flag' => '0',
            ' and ',
            'file_name' => $file,
        ));
        $data = $this->manipulator->fetch();
        $result = ($data['file_name'] == $file);
        return $result;
    }

    public function insert(array $data)
    {
        $this->manipulator->columns(
            'file_name', 'xml_contents', 'doctor_id', 'card_number'
            , 'patient_code', 'export_flag', 'date_regist'
        );
        $this->manipulator->values(array(
            'file_name'    => $data['file_name'], 
            'xml_contents' => $data['xml_contents'], 
            'doctor_id'    => $data['doctor_id'], 
            'card_number'  => $data['card_number'], 
            'patient_code' => $data['patient_code'], 
            'export_flag'  => '0', 
            'date_regist'  => date('Y-m-d H:i:s'), 
        ));
       return $this->manipulator->insert();
    }

    public function update_flag($id)
    {
        $this->manipulator->set(array(
            'export_flag' => '1', 
        ));
        $this->manipulator->where(array(
            $this->pkey => $id,
        ));
        return $this->manipulator->update();
    }

}

?>
