<?php
/**
 * Date class
 *
 * @package Lambda/lib
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 *
 */

class Date
{
    /**
     * 和暦を返却する
     *
     * @param int $star 開始年(西暦)
     * @param int $end  終了年(西暦)
     * @param str $format フォーマット
     * @return array
     */
    public static function getWareki($start, $end, $format = '西暦%year%年 (%wareki%年)')
    {
        $buf = array();
        for ($i = $start; $i <= $end; $i++) {
            $wareki = '';
            if (1868 <= $i && $i <= 1911) {
                $wareki = '明治' . ($i - 1867);
            } else if (1912 <= $i && $i <= 1925) {
                $wareki = '大正' . ($i - 1911);
            } else if (1926 <= $i && $i <= 1988) {
                $wareki = '昭和' . ($i - 1925);
            } else if (1989 <= $i) {
                $wareki = '平成' . ($i - 1988);
            }
            $buf[$i] = str_replace(array('%year%', '%wareki%'), array($i, $wareki), $format);
        }
        return $buf;
    }



} // -- End of Dir class



