<?php
/**
 * 医師クッキー class
 *
 * PHP version 5
 *
 */

require_once dirname(__FILE__).'/Vigenere.php';

class DocCookie
{
    const COOKIE_USERNAME = 'doc_user_name_0519';
    const COOKIE_USER_ID  = 'doc_user_id_0519';
    const COOKIE_USER_DIV = 'doc_user_div_0519';

    const LOGIN_EXPIRE    = 86400;
    const CRYPT_KEY       = 'megro-street-child-clinic-doc';

    public static function unsetAll()
    {
        self::unsetUserName();
        self::unsetUserId();
        self::unsetUserDiv();
        $_COOKIE = array();
    }

    public static function setUserName($user_name)
    {
        $enc = self::encode(self::COOKIE_USERNAME.':'.$user_name, self::CRYPT_KEY);
        $expire = time() + self::LOGIN_EXPIRE;
        $res = setcookie(self::COOKIE_USERNAME, $enc, $expire, self::getCookiePath(), self::getCookieDomain());
    }
    public static function getUserName()
    {
        if (isset($_COOKIE[self::COOKIE_USERNAME])) {
            $dec = self::decode($_COOKIE[self::COOKIE_USERNAME], self::CRYPT_KEY);
            list( , $user_name) = (strpos($dec, ':') !== false) ? explode(':', $dec, 2) : array('', '');
            return $user_name;
        }
        return '';
    }
    protected static function unsetUserName()
    {
        $expire = time() - self::LOGIN_EXPIRE;
        setcookie(self::COOKIE_USERNAME, '', $expire, self::getCookiePath(), self::getCookieDomain());
    }



    public static function setUserId($user_id)
    {
        $enc = self::encode(self::COOKIE_USER_ID.':'.$user_id, self::CRYPT_KEY);
        $expire = time() + self::LOGIN_EXPIRE;
        setcookie(self::COOKIE_USER_ID, $enc, $expire, self::getCookiePath(), self::getCookieDomain());
    }
    public static function getUserId()
    {
        if (isset($_COOKIE[self::COOKIE_USER_ID])) {
            $dec = self::decode($_COOKIE[self::COOKIE_USER_ID], self::CRYPT_KEY);
            list( , $user_id) = (strpos($dec, ':') !== false) ? explode(':', $dec, 2) : array('', '');
            return $user_id;
        }
        return '';
    }
    protected static function unsetUserId()
    {
        $expire = time() - self::LOGIN_EXPIRE;
        setcookie(self::COOKIE_USER_ID, '', $expire, self::getCookiePath(), self::getCookieDomain());
    }




    public static function setUserDiv($user_div)
    {
        $enc = self::encode(self::COOKIE_USER_DIV.':'.$user_div, self::CRYPT_KEY);
        $expire = time() + self::LOGIN_EXPIRE;
        setcookie(self::COOKIE_USER_DIV, $enc, $expire, self::getCookiePath(), self::getCookieDomain());
    }
    public static function getUserDiv()
    {
        if (isset($_COOKIE[self::COOKIE_USER_DIV])) {
            $dec = self::decode($_COOKIE[self::COOKIE_USER_DIV], self::CRYPT_KEY);
            list( , $user_div) = (strpos($dec, ':') !== false) ? explode(':', $dec, 2) : array('', '');
            return $user_div;
        }
        return '';
    }
    protected static function unsetUserDiv()
    {
        $expire = time() - self::LOGIN_EXPIRE;
        setcookie(self::COOKIE_USER_DIV, '', $expire, self::getCookiePath(), self::getCookieDomain());
    }




    /**
     * @access private
     * @static
     */
    private static function getCookieDomain()
    {
        if (preg_match('/^[0-9.]+$/', $_SERVER['HTTP_HOST'])) {
            // IPアドレス
            return $_SERVER['HTTP_HOST'];
        }

        // 先頭にドットを加えて返却 (www. で始まる場合、www. を除去)
        // [todo] www.com や www.co.jp では意図しない戻り値になるので注意。
        return '.' . preg_replace('/^www\./i', '', $_SERVER['HTTP_HOST']);
    }

    /**
     * @access private
     */
    private static function getCookiePath()
    {
        return '/';
    }

    /**
     * @access private
     */
    private static function encode($string, $key)
    {
        $string = base64_encode($string);
        return Vigenere::encrypt($string, $key);
    }

    /**
     * @access private
     */
    private static function decode($string, $key)
    {
        $ret = Vigenere::decrypt($string, $key);
        return base64_decode($ret);
    }



} // -- End of class


