<?php
/**
 * String class
 *
 * @package Lambda/lib
 * @author  rooth
 * @version 0.0.1
 *
 * PHP version 5
 *
 */

class String
{
    protected static $charset = 'UTF-8';

    /**
     * recursive htmlspecialchars
     * @param mixed $mixed
     */
    public static function rh($mixed)
    {
        if (is_scalar($mixed) && ! is_bool($mixed)) {
            return htmlspecialchars($mixed, ENT_QUOTES, self::$charset);
        } elseif (is_array($mixed)) {
            return array_map(array('self', 'rh'), $mixed);
        } else {
            return $mixed;
        }
    }

    /**
     * mb_trim
     *
     *   文字コード「utf-8」のみ対応。
     *
     * @param mixed $mixed
     */
    public static function mb_trim($mixed)
    {
        if (is_scalar($mixed) && ! is_bool($mixed)) {
            return preg_replace('/^[\s\0　]+|[\s\0　]+$/u', '', $mixed);
        } elseif (is_array($mixed)) {
            return array_map(array('self', 'mb_trim'), $mixed);
        } else {
            return $mixed;
        }
    }

    /**
     * mb_ltrim
     *
     *   文字コード「utf-8」のみ対応。
     *
     * @param mixed $mixed
     */
    public static function mb_ltrim($mixed)
    {
        if (is_scalar($mixed) && ! is_bool($mixed)) {
            return preg_replace('/^[\s\0　]+/u', '', $mixed);
        } elseif (is_array($mixed)) {
            return array_map(array('self', 'mb_ltrim'), $mixed);
        } else {
            return $mixed;
        }
    }

    /**
     * mb_rtrim
     *
     *   文字コード「utf-8」のみ対応。
     *
     * @param mixed $mixed
     */
    public static function mb_rtrim($mixed)
    {
        if (is_scalar($mixed) && ! is_bool($mixed)) {
            return preg_replace('/[\s\0　]+$/u', '', $mixed);
        } elseif (is_array($mixed)) {
            return array_map(array('self', 'mb_rtrim'), $mixed);
        } else {
            return $mixed;
        }
    }

    /**
     * ntrim
     *
     *   文字コード「utf-8」のみ対応。
     *
     * @param mixed $mixed
     */
    public static function ntrim($mixed)
    {
        if (is_scalar($mixed) && ! is_bool($mixed)) {

            // 制御文字(TAB, LF, CR, SPACE以外)をすべて除去
            // (x09: TAB / x0a: LF / x0d: CR / x20: SPACE)
            $mixed = preg_replace('/[\x00-\x08\x0b\x0c\x0e-\x1f\x7f]/u', '', $mixed);

            // 前後のホワイトスペース、全角スペースを除去
            $mixed = preg_replace('/^[\s　]+|[\s　]+$/u', '', $mixed);

            return $mixed;

        } elseif (is_array($mixed)) {
            return array_map(array('self', 'ntrim'), $mixed);
        } else {
            return $mixed;
        }
    }

    /**
     * base64_urlencode
     *  for uri safe encode
     *
     * @param str $str plain text
     */
    public static function base64_urlencode($str)
    {
        $str = base64_encode($str);
        return str_replace(array('+', '/', '='), array('-', '_', ''), $str);
    }

    /**
     * base64_urldecode
     * @param str $str self::base64_urlencode encoded string
     */
    public static function base64_urldecode($str)
    {
        $str = str_replace(array('-', '_'), array('+', '/'), $str);
        $padding_num = (4 - (strlen($str) % 4)) % 4; // =パディングが必要な数
        return base64_decode($str.str_repeat('=', $padding_num));
    }

    /**
     * md5_repeat
     *
     * @param str $str 対象文字列
     * @param int $salt ソルト
     * @param int $repeat 繰り返し回数
     */
    public static function md5_repeat($str, $salt = '', $repeat = 1)
    {
        $x = '';
        for ($i = 0; $i < $repeat; $i++) {
            $x = md5($x . $str . $salt);
        }
        return $x;
    }

    /**
     * mb_strimwidth のラッパー
     *
     *   文字数の扱い：文字コードにかかわらず、半角を１文字、全角を２文字、そしてトリムマーカーも含める
     *
     * @param str $str 対象文字列
     * @param int $width 文字幅
     * @param str $suffix トリムマーカー
     * @param str $encoding 文字エンコーディング
     */
    public static function mbChunk($str, $width, $suffix = '…', $encoding = 'utf-8')
    {
        return mb_strimwidth($str, 0, $width, $suffix, $encoding);
    }

    /**
     * ファイル名を「拡張子を除く部分」と「拡張子」に分割する
     *
     *  5.2.0 以上は、以下のビルトイン関数を推奨
     *
     *    $fname = pathinfo($filename, PATHINFO_FILENAME);
     *    $ext   = pathinfo($filename, PATHINFO_EXTENSION);
     *
     * @param  string $fname ファイル名
     * @return array array('拡張子を除く部分', '拡張子')
     */
    public static function splitFnameExt($fname)
    {
        if (strpos($fname, '.') !== false) {
            $arr = explode('.', $fname);
            $ext   = array_pop($arr);
            $fname = implode('.', $arr);

            return array($fname, $ext);
        }

        return array('', '');
    }

    /**
     * explode のラッパー
     *
     *   limit を必須にすることで、返却要素数を保証する
     *
     * @param str $delim 区切り文字列
     * @param str $str   入力文字列
     * @param int $limit 返却する要素数
     * @param str $fallback 存在しない時の代替
     */
    public static function explode($delim, $str, $limit, $fallback = '')
    {
        $buf = explode($delim, $str);

        $ret = array();
        for ($i = 0; $i < $limit; $i++) {
            $ret[] = isset($buf[$i]) ? $buf[$i] : $fallback;
        }

        return $ret;
    }

    /**
     * Copyright © yyyy - yyyy
     *
     * @param int $year 開始年
     */
    public static function copyrightYear($year)
    {
        $yyyy = date('Y');
        if ($yyyy == $year) return $year;
        if ($yyyy > $year)  return "{$year} - {$yyyy}";
        return '';
    }



} // -- End of Dir class



